#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 09:04:02 2019

@author: yannbrunel
"""
import numpy as np
import matplotlib.pyplot as plt
# le début du script est le même qu'en première
#%%
t=8*np.arange(11) # crée un liste de 11 valeurs séparées de 8 (8jours)
Xmes=np.array([-0.2,2.9,5.4,6.4,5,1.2,-3.4,-6.4,-6.9,-5.7,-3.3]) # pointé des positions selon X
Ymes=np.array([-8.2,-7.3,-4.9,-1.2,2.9,5.3,4.7,1.5,-2.3,-5.5,-7.5])# idem sur Y
x=Xmes*0.46/8.2 #remise à l'échelle en U.A
y=Ymes*0.46/8.2 # idem

#%%
vxl=[] # initialise une liste vide
m=np.arange(len(t)-2) #redimensionne la liste pour lui donner la bonne taille
for i in m : # construction en boucle de la composante horizontale de la vitesse 
    vx=(x[i+2]-x[i])/(t[i+2]-t[i]) # construction de vx avec une méthode en 3 points
    vxl.append(vx) #on ajoute le vx calculé précédemment à la liste des vxl

vyl=[] #idem pour la composante verticale
m=np.arange(len(t)-2)
for i in m :
    vy=(y[i+2]-y[i])/(t[i+2]-t[i])
    vyl.append(vy)
#%%
dx=x[:-1]*1.5*10**11 # on redimensionne la liste et on convertit en mètres
dy=y[:-1]*1.5*10**11 #idem

vyln=1.5*10**11*np.array(vyl)/(24*3600) # on redimensionne et on convertit le temps en seconde
vxln=1.5*10**11*np.array(vxl)/(24*3600) #idem
dxn=dx[1:] # enlève le premier terme de la liste et renomme. 
dyn=dy[1:] #idem pour y


Cs=(dxn*vyln-dyn*vxln) # on utilise la définition de la constante des aires par le produit vectoriel de OM et v
n=np.arange(len(t)-2) #redimensionne
plt.plot(n,Cs,'bo',label='constante des aires') #options de tracé
plt.grid()
plt.xlabel('point de mesure')
plt.ylabel('valeur de C')
mod=np.polyfit(n,Cs,0)
Cmods=float(mod[0]) # définit le modèle constant et le flottant correspondant. 
print('la constante des aires est de l ordre de ',"%.1e"%Cmods)
Cmodgs=0*n+mod[0] # crée une liste nulle de la bonne longueur, pour pouvoir tracer. 
plt.plot(n,Cmodgs,'r-',label="modèle") #tracé
plt.ylim(0,3*10**15)
plt.legend()    